
-- Rain parameters
kPPS = 20;               -- Number of particles generated per second
kGravity = 20 ;            -- Gravity in pixels/second/second

-- kBlendNormal
-- kBlendOpaque
-- kBlendAdditive
-- kBlendAdditiveAlpha
-- kBlendSubtractive
-- kBlendLit

function Init()
  SetTexture("heart");
  SetBlendMode(kBlendNormal);
  SetNumParticles(15);
end

floor = math.floor

ParticlesPerSecond = NewParticleGenerator();

StopSpouting = NewTimeout(1000);
TestDone = NewTimeout(5500);

function Update(ms)
  if (TestDone(ms)) then
    SetDone();
    return ;
  end
  local newParticles = ParticlesPerSecond( kPPS,ms );

  if (not StopSpouting(ms)) then
   InitScale( "fRange", 0.1, .2 );
   InitAge("iRange", 300, 800);
   InitExtra1("fRange",0,1);
   InitPosition( "vRange", Vec3(-15,-15,0), Vec3(15,25,0) );
   InitVelocity( "vRange", Vec3(-70,-70,0), Vec3(80, -80, 0));
   CreateParticles(newParticles);
  end

  Gravity(kGravity);

   Do("move");
   DoAge("iAge");
   Do("expire", 1700)

   DoUp( "vRotate", 0, 0 );

end

